// graphics.c

#include <stdlib.h>
 
#include "main.h"
#include "players.h"
#include "graphics.h"
#include "gworld.h"
#include "moving.h"
#include "wdef.h"
#include "tweak.h"
#include "gameticks.h"
#include "blitter.h"
#include "victory.h"
#include "stringtools.h"
#include "register.h"
#include "grays.h"
#include "level.h"
#include "keyselect.h"

CGrafPtr backdropPort = nil;
GWorldPtr backdropWorld = nil;

void DrawSpriteBlobs( int player, int type )
{
	Rect firstRect, secondRect, thirdRect;
	const int repeat = 0xFF, forever = 0xFE;
	
	static const unsigned char blobAnimation[6][2][25] = 
	{ 
	    { { kNoSuction,       kNoSuction,       kNoSuction,       kNoSuction,
	        kNoSuction,       kNoSuction,       kNoSuction,       kNoSuction,
	        kNoSuction,       kNoSuction,       kNoSuction,       kNoSuction,       
		    kFlashBrightBlob, kFlashBrightBlob, kFlashBrightBlob, kFlashBrightBlob,
		    kFlashBrightBlob, kFlashBrightBlob, kFlashBrightBlob, kFlashBrightBlob,
		    kFlashBrightBlob, kFlashBrightBlob, kFlashBrightBlob, kFlashBrightBlob, repeat }, 
		  { kNoSuction,       kNoSuction,       kNoSuction,       kNoSuction,
		    kNoSuction,       kNoSuction,       kNoSuction,       kNoSuction,
		    kNoSuction,       kNoSuction,       kNoSuction,       kNoSuction,
		    kNoSuction,       kNoSuction,       kNoSuction,       kNoSuction,
		    kNoSuction,       kNoSuction,       kNoSuction,       kNoSuction,
		    kNoSuction,       kNoSuction,       kNoSuction,       kNoSuction, repeat } },
		{ { kNoSuction,       kSquish,          kNoSuction,       kSquash,        
		    kNoSuction,       kSquish,          kNoSuction,       kSquash,
		    kNoSuction,       forever },
		  { kNoSuction,       kSquish,          kNoSuction,       kSquash,        
		    kNoSuction,       kSquish,          kNoSuction,       kSquash,
		    kNoSuction,       forever } },
		{ { kSobBlob,         kSobBlob,         kSobBlob,         kSobBlob,         
			kSob2Blob,        kSob2Blob,        kSob2Blob,        kSob2Blob,        
			repeat },
		  { kSobBlob,         kSobBlob,         kSobBlob,         kSobBlob,         
			kSob2Blob,        kSob2Blob,        kSob2Blob,        kSob2Blob,        
			repeat } },
		{ { kBombFuse1,       kBombFuse2,       kBombFuse3,       repeat }, 
		  { kBombFuse1,       kBombFuse2,       kBombFuse3,       repeat } }, 
		{ { kBlinkBomb1,      kBombFuse2,       kBlinkBomb3,      kBombFuse1,        
		    kBlinkBomb2,      kBombFuse3,       repeat },
		  { kBlinkBomb1,      kBombFuse2,       kBlinkBomb3,      kBombFuse1,        
		    kBlinkBomb2,      kBombFuse3,       repeat } }
	};
	
	if( grenade[player] ) type += 3;
	
	PrepareForGDrawing( playerSpriteWorld[player] );

	if( blobAnimation[type][0][anim[player]] == forever ) anim[player]--;
	if( blobAnimation[type][0][anim[player]] == repeat  ) anim[player] = 0;
	
	CalcBlobRect( blobX[player], blobY[player], &firstRect );
	if( halfway[player] ) OffsetRect( &firstRect, 0, kBlobVertSize / 2 );
	
	TweakFirstBlob ( player, &firstRect );
	secondRect = firstRect;
	TweakSecondBlob( player, &secondRect );
		
	thirdRect = firstRect;
	thirdRect.top    -= kBlobShadowError;
	thirdRect.left   -= kBlobShadowError;
	thirdRect.right  += kBlobShadowDepth + kBlobShadowError;
	thirdRect.bottom += kBlobShadowDepth + kBlobShadowError;
	CleanSpriteArea( player, &thirdRect );
							
	thirdRect = secondRect;
	thirdRect.top    -= kBlobShadowError;
	thirdRect.left   -= kBlobShadowError;
	thirdRect.right  += kBlobShadowDepth + kBlobShadowError;
	thirdRect.bottom += kBlobShadowDepth + kBlobShadowError;
	CleanSpriteArea( player, &thirdRect );
	
	thirdRect = firstRect;
	OffsetRect( &thirdRect, shadowDepth[player], shadowDepth[player] );
	DrawShadow( &thirdRect,  colorA[player], blobAnimation[type][0][anim[player]] );

	thirdRect = secondRect;
	OffsetRect( &thirdRect, shadowDepth[player], shadowDepth[player] );
	DrawShadow( &thirdRect, colorB[player], blobAnimation[type][1][anim[player]] );

	DrawSprite( &firstRect,  colorA[player], blobAnimation[type][0][anim[player]] );
	
	DrawSprite( &secondRect, colorB[player], blobAnimation[type][1][anim[player]] );
	
	FinishGDrawing( playerSpriteWorld[player] );
}

void CleanSpriteArea( int player, Rect *myRect )
{
	PrepareForGDrawing( playerSpriteWorld[player] );
	CopyBits( GetPortBitMapForCopyBits(playerWorld[player]),
			  GetPortBitMapForCopyBits(playerSpriteWorld[player]),
			   myRect, myRect,
			   srcCopy, nil );
	FinishGDrawing( playerSpriteWorld[player] );
	
	SetUpdateRect( player, myRect );
}

void EraseSpriteBlobs( int player )
{
	Rect myRect, secondRect;
	
	CalcBlobRect( blobX[player], blobY[player], &myRect );
	if( halfway[player] ) OffsetRect( &myRect, 0, kBlobVertSize / 2 );

	TweakFirstBlob( player, &myRect );
	secondRect = myRect;
	secondRect.top    -= kBlobShadowError;
	secondRect.left   -= kBlobShadowError;
	secondRect.right  += kBlobShadowDepth + kBlobShadowError;
	secondRect.bottom += kBlobShadowDepth + kBlobShadowError;
	CleanSpriteArea( player, &secondRect );

	TweakSecondBlob( player, &myRect );
	myRect.top    -= kBlobShadowError;
	myRect.left   -= kBlobShadowError;
	myRect.right  += kBlobShadowDepth + kBlobShadowError;
	myRect.bottom += kBlobShadowDepth + kBlobShadowError;
	CleanSpriteArea( player, &myRect );
}

void CalcBlobRect( int x, int y, Rect *myRect )
{
	myRect->top = y * kBlobVertSize;
	myRect->left = x * kBlobHorizSize;
	myRect->bottom = myRect->top + kBlobVertSize;
	myRect->right = myRect->left + kBlobHorizSize;
}

void InitBackdrop( void )
{
	Rect windowRect;
		
	GetPortBounds( backdropPort, &windowRect );
	InitGWorld( &backdropWorld, &windowRect, 16 );
	DrawPictInGWorld( backdropWorld, picBackdrop );
}

void DrawBackdrop( void )
{
	Rect backdropRect;
	
	SetPort( backdropPort );
	
	GetPortBounds( backdropWorld, &backdropRect );	
	CopyBits( GetPortBitMapForCopyBits( backdropWorld ), GetPortBitMapForCopyBits( backdropPort ),
				&backdropRect, &backdropRect, srcCopy, nil );
}

void OpeningProgress( int current, int total ) 
{
#if 0 // computers are fast now... progress bar seems silly
	Rect myRect = {450, 220, 464, 420};
	RGBColor shadeUpperLeft   =   { 0xAAAA, 0xAAAA, 0xAAAA },
	 		 shadeLowerRight  =   { 0xFFFF, 0xFFFF, 0xFFFF },
	 		 shadeOutline     =   { 0x0000, 0x0000, 0x0000 },
	 		 shadeInnerDark   =   { 0x5555, 0x5555, 0x5555 },
	 		 shadeInnerTop    =   { 0x8888, 0x8888, 0x8888 },
	 		 shadeInnerCenter =	  { 0xBBBB, 0xBBBB, 0xBBBB },
	 		 shadeInnerBottom =   { 0xDDDD, 0xDDDD, 0xDDDD },
	 		 blues[]          = { { 0x0000, 0x0000, 0x5555 },
	 		 				 	  { 0x3333, 0x3333, 0x9999 },
	 		 					  { 0x6666, 0x6666, 0xCCCC },
	 		 					  { 0x9999, 0x9999, 0xFFFF },
	 		 					  { 0xCCCC, 0xCCCC, 0xFFFF },
	 		 					  { 0xFFFF, 0xFFFF, 0xFFFF } };

	int pLeft, pRight, count;
				
	SetPort( backdropPort );
	
	RGBForeColor( &shadeUpperLeft );
	MoveTo( myRect.left, myRect.bottom-2 );
	LineTo( myRect.left, myRect.top );
	LineTo( myRect.right-1, myRect.top );
	RGBForeColor( &shadeLowerRight );
	MoveTo( myRect.right-1, myRect.top+1 );
	LineTo( myRect.right-1, myRect.bottom-1 );
	LineTo( myRect.left, myRect.bottom-1 );
	
	InsetRect( &myRect, 1, 1 );
	RGBForeColor( &shadeOutline );
	FrameRect( &myRect );
	
	InsetRect( &myRect, 1, 1 );

	if( current > 0 )
	{
		pLeft = myRect.left;
		pRight = pLeft + ((myRect.right - pLeft) * current / total);
		
		RGBForeColor( &blues[0] );
		MoveTo( pLeft+2, myRect.bottom-1 );
		LineTo( pRight-2, myRect.bottom-1 );
		LineTo( pRight-2, myRect.top+1 );
		
		RGBForeColor( &blues[1] );
		MoveTo( pLeft+1, myRect.bottom-1 );
		LineTo( pLeft+2, myRect.bottom-2 );
		LineTo( pRight-3, myRect.bottom-2 );
		LineTo( pRight-3, myRect.top+2 );
		MoveTo( pRight-2, myRect.top );
		LineTo( pLeft+2, myRect.top );
		
		RGBForeColor( &blues[2] );
		MoveTo( pRight-3, myRect.top+1 );
		LineTo( pLeft+2, myRect.top+1 );
		LineTo( pLeft+1, myRect.top );
		LineTo( pLeft, myRect.top );
		LineTo( pLeft, myRect.bottom-1 );
		LineTo( pLeft+2, myRect.bottom-3 );
		LineTo( pRight-4, myRect.bottom-3 );
		
		RGBForeColor( &blues[3] );
		MoveTo( pLeft+1, myRect.top+1 );
		LineTo( pLeft+2, myRect.top+2 );
		LineTo( pRight-4, myRect.top+2 );
		MoveTo( pLeft+1, myRect.bottom-3 );
		LineTo( pLeft+2, myRect.bottom-4 );
		LineTo( pRight-4, myRect.bottom-4 );
		
		RGBForeColor( &blues[4] );
		MoveTo( pLeft+1, myRect.top+2 );
		LineTo( pLeft+2, myRect.top+3 );
		LineTo( pRight-4, myRect.top+3 );
		LineTo( pRight-4, myRect.bottom-5 );
		LineTo( pLeft+2, myRect.bottom-5 );
		LineTo( pLeft+1, myRect.bottom-4 );

		RGBForeColor( &blues[5] );
		MoveTo( pLeft+1, myRect.top+3 );
		LineTo( pLeft+1, myRect.bottom-5 );
		for( count=myRect.top+4; count<=myRect.bottom-6; count++ )
		{
			MoveTo( pLeft+2, count );
			LineTo( pRight-5, count );
		}
		
		RGBForeColor( &shadeOutline );
		MoveTo( pRight-1, myRect.top );
		LineTo( pRight-1, myRect.bottom-1 );
		
		if( current < total )
		{
			RGBForeColor( &shadeInnerDark );
			MoveTo( pRight, myRect.top );
			LineTo( pRight, myRect.bottom-1 );
		}
		
		myRect.left = pRight+1;
	}
	
	if( current < total )
	{
		RGBForeColor( &shadeInnerCenter );
		PaintRect( &myRect );
		
		RGBForeColor( &shadeInnerTop );
		MoveTo( myRect.left, myRect.bottom-2 );
		LineTo( myRect.left, myRect.top );
		LineTo( myRect.right-1, myRect.top );
		
		RGBForeColor( &shadeInnerBottom );
		MoveTo( myRect.left+1, myRect.bottom-1 );
		LineTo( myRect.right-1, myRect.bottom-1 );
		LineTo( myRect.right-1, myRect.top );
	}
#endif

	current, total;
}

void ShowTitle( void )
{
	Boolean registered = IsRegistered( );
	int time;
	
	if( kUseDrawSprocket )
	{
		DSpContext_GetFrontBuffer( context, &backdropPort );
	}
	else
	{
		WindowRef backdropWindow;
		Rect windowBounds = { 0, 0, 480, 640 };
		WindowDefSpec windowSpec;

		windowSpec.defType  = kWindowDefProcID;
		windowSpec.u.procID = kWindowPlainDialogProc;
		CreateCustomWindow( &windowSpec, 
							kFloatingWindowClass, 
							0,
							&windowBounds, 
							&backdropWindow );
		RepositionWindow( backdropWindow, nil, kWindowCenterOnMainScreen);
		backdropPort = GetWindowPort(backdropWindow);
	}
	
	DrawPictInPort( backdropPort, picTitle );

	SetPort( backdropPort );
	TextFont( 3 );
	TextFace( bold );
	
/*	if( pirateCode )
	{
		TextSize( 20 );

		width = StringWidth( "\pSoftware piracy is a crime!!" );
		MoveTo( 320 - (width/2), 50 );

		ForeColor( redColor );
		DrawShadowText( "\pSoftware piracy is a crime!!" );
	}
	else if( !registered )
	{
		TextSize( 9 );

		width = StringWidth( "\pUnregistered Version: Please Register!" );
		MoveTo( 320 - (width/2), 50 );

		ForeColor( redColor );
		DrawShadowText( "\pUnregistered Version: " );

		ForeColor( greenColor );
		DrawShadowText( "\pPlease Register!" );
	}
*/
	QuickFadeIn( nil );	

	time = TickCount() + 180;

	RetrieveResources( );
	
	while( time > TickCount() && !Button() )
	{
	}
	
	while( Button() )
	{
	}
	
	QuickFadeOut( nil );
}

